'use strict';

const { AlipaySdk } = require('alipay-sdk');
const fs = require('fs');
const moment = require("moment-timezone");

let alipaySdk;

try {
    alipaySdk = new AlipaySdk({
    // 设置支付宝应用 ID
    appId: "",
    // 设置应用私钥
    privateKey: fs.readFileSync('./private-key.pem', 'ascii'),
    // 设置支付宝公钥
    alipayPublicKey: fs.readFileSync('./alipay-public-key.pem', 'ascii'),
    // 设置网关地址，默认是 https://openapi.alipay.com/gateway.do
    // 沙盒测试地址：https://openapi-sandbox.dl.alipaydev.com/gateway.do
    gateway: "https://openapi-sandbox.dl.alipaydev.com/gateway.do",
    })
} catch (err) {
    console.error('初始化支付宝SDK失败:', err);
    process.exit(1);
}

exports.alipaySdk = alipaySdk;

// 同步回调地址
exports.returnUrl= "";
// 异步回调地址
exports.notifyUrl = "";

exports.formatAndValidateExpiredAt = function(expiredAt) {
    let result = {
        formattedDate: null,
        error: null
    };
    if (expiredAt !== undefined) {
        let date = new Date(expiredAt);
        if(date.toString() === 'Invalid Date') {
            console.log('Variable expiredAt is not a valid time:', expiredAt);
            result.error = {
                statusCode: 400,
                headers: {"Content-Type":"application/json"},
                body: "invalid expiredAt. not a valid time.",
            };
            return result
        }
        if (date.getTime() <= Date.now()) {
            console.log('Variable expiredAt should after now time:', expiredAt);
            result.error = {
                statusCode: 400,
                headers: {"Content-Type":"application/json"},
                body: "invalid expiredAt. should after now time.",
            };
            return result
        }

        result.formattedDate = moment.utc(expiredAt).tz("Asia/Shanghai").format('YYYY-MM-DD HH:mm:ss')
        console.log('converted expiredAt:', result.formattedDate);
    }
    return result;
}


